<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;

class Cartmodel extends Model 
{

    protected $table = 'cart';
    public $timestamps = true;
    protected $fillable = array('user_id', 'product_id');
    protected $visible = array('user_id', 'product_id');

    public function product()
    {
        return $this->hasMany('ProductModel', 'product_id');
    }

    public function user()
    {
        return $this->belongsTo('UserModel', 'user_id');
    }

}